/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.http;

import jade.core.BackEnd;
import jade.core.FEConnectionManager;
import jade.core.FrontEnd;
import jade.core.IMTPException;
import jade.core.Timer;
import jade.core.TimerDispatcher;
import jade.core.TimerListener;
import jade.imtp.leap.BackEndStub;
import jade.imtp.leap.ConnectionListener;
import jade.imtp.leap.Dispatcher;
import jade.imtp.leap.FrontEndSkel;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.JICPAddress;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.JICP.JICPProtocol;
import jade.imtp.leap.MicroSkeleton;
import jade.imtp.leap.http.HTTPClientConnection;
import jade.mtp.TransportAddress;
import jade.util.Logger;
import jade.util.leap.Properties;
import java.io.IOException;
import java.util.Vector;

public class HTTPFEDispatcher
extends Thread
implements FEConnectionManager,
Dispatcher,
TimerListener {
    private MicroSkeleton mySkel;
    private BackEndStub myStub;
    private Thread terminator;
    private DisconnectionManager myDisconnectionManager;
    private KeepAliveManager myKeepAliveManager;
    private InputManager myInputManager;
    private int outCnt;
    private boolean waitingForFlush = false;
    private long maxDisconnectionTime;
    private long keepAliveTime;
    private Properties props;
    private TransportAddress mediatorTA;
    private String myMediatorID;
    private String owner;
    private String beAddrsText;
    private String[] backEndAddresses;
    private ConnectionListener myConnectionListener;
    private Object connectorLock = new Object();
    private boolean locked = false;
    private int verbosity = 1;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());
    protected String myMediatorClass = "jade.imtp.leap.http.HTTPBEDispatcher";
    private JICPPacket lastResponse = null;
    private byte lastSid = (byte)16;
    private int cnt = 0;

    public BackEnd getBackEnd(FrontEnd fe, Properties p) throws IMTPException {
        String tmp;
        this.props = p;
        this.beAddrsText = this.props.getProperty("beaddrs");
        this.backEndAddresses = this.parseBackEndAddresses(this.beAddrsText);
        String host = this.props.getProperty("host");
        if (host == null) {
            host = "localhost";
        }
        int port = 1099;
        try {
            port = Integer.parseInt(this.props.getProperty("port"));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        this.mediatorTA = JICPProtocol.getInstance().buildAddress(host, String.valueOf(port), null, null);
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Remote URL is http://" + host + ":" + port);
        }
        if ((tmp = this.props.getProperty("mediator-class")) != null) {
            this.myMediatorClass = tmp;
        } else {
            this.props.setProperty("mediator-class", this.myMediatorClass);
        }
        if (this.myLogger.isLoggable(Logger.CONFIG)) {
            this.myLogger.log(Logger.CONFIG, "Mediator class=" + this.myMediatorClass);
        }
        long retryTime = 10000L;
        try {
            retryTime = Long.parseLong(this.props.getProperty("reconnection-retry-time"));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Reconnection retry time is " + retryTime);
        }
        this.maxDisconnectionTime = 600000L;
        try {
            this.maxDisconnectionTime = Long.parseLong(this.props.getProperty("max-disconnection-time"));
        }
        catch (Exception e) {
            this.props.setProperty("max-disconnection-time", String.valueOf(this.maxDisconnectionTime));
        }
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Max disconnection time is " + this.maxDisconnectionTime);
        }
        this.keepAliveTime = 60000L;
        try {
            this.keepAliveTime = Long.parseLong(this.props.getProperty("keep-alive-time"));
        }
        catch (Exception e) {
            this.props.setProperty("keep-alive-time", String.valueOf(this.keepAliveTime));
        }
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Keep-alive time is " + this.keepAliveTime);
        }
        this.myDisconnectionManager = new DisconnectionManager(retryTime, this.maxDisconnectionTime);
        this.myKeepAliveManager = new KeepAliveManager(this.keepAliveTime);
        this.myInputManager = new InputManager();
        this.owner = this.props.getProperty("owner");
        this.myStub = new BackEndStub(this);
        this.mySkel = new FrontEndSkel(fe);
        this.myInputManager.start();
        this.createBackEnd();
        return this.myStub;
    }

    public void shutdown() {
        block3: {
            this.myInputManager.kill();
            this.terminator = Thread.currentThread();
            if (this.terminator == this) break block3;
            JICPPacket pkt = new JICPPacket(0, 0, null);
            if (this.myDisconnectionManager.isReachable()) {
                this.myLogger.log(Logger.FINE, "Pushing termination notification");
                try {
                    this.deliver(pkt, null);
                }
                catch (IOException ioe) {
                    this.myLogger.log(Logger.FINE, "BackEnd closed");
                }
            }
        }
    }

    private synchronized void createBackEnd() throws IMTPException {
        String createMediatorRequest = new String(BackEndStub.encodeCreateMediatorRequest(this.props));
        JICPPacket pkt = new JICPPacket(22, 0, null, createMediatorRequest.getBytes());
        int i = -1;
        while (i < this.backEndAddresses.length) {
            if (i >= 0) {
                String addr = this.backEndAddresses[i];
                int colonPos = addr.indexOf(58);
                String host = addr.substring(0, colonPos);
                String port = addr.substring(colonPos + 1, addr.length());
                this.mediatorTA = new JICPAddress(host, port, this.myMediatorID, "");
            }
            try {
                this.myLogger.log(Logger.INFO, "Creating BackEnd on http://" + this.mediatorTA.getHost() + ":" + this.mediatorTA.getPort());
                pkt = this.deliver(pkt, null);
                String replyMsg = new String(pkt.getData());
                if (pkt.getType() != 100) {
                    BackEndStub.parseCreateMediatorResponse(replyMsg, this.props);
                    this.myMediatorID = this.props.getProperty("mediator-id");
                    this.mediatorTA = new JICPAddress(this.mediatorTA.getHost(), this.mediatorTA.getPort(), this.myMediatorID, null);
                    this.myDisconnectionManager.setReachable();
                    this.myKeepAliveManager.update();
                    this.myLogger.log(Logger.INFO, "BackEnd OK. Mediator ID is " + this.myMediatorID);
                    return;
                }
                this.myLogger.log(Logger.WARNING, "Mediator error: " + replyMsg);
            }
            catch (IOException ioe) {
                this.myLogger.log(Logger.WARNING, "Connection error. " + ioe.toString());
            }
            ++i;
        }
        throw new IMTPException("Error creating the BackEnd.");
    }

    public synchronized byte[] dispatch(byte[] payload, boolean flush) throws ICPException {
        if (this.myDisconnectionManager.isReachable()) {
            if (this.waitingForFlush && !flush) {
                throw new ICPException("Upsetting dispatching order");
            }
            this.waitingForFlush = false;
            int sid = this.outCnt;
            this.outCnt = this.outCnt + 1 & 0xF;
            this.log("Issuing outgoing command " + sid, 3);
            try {
                JICPPacket pkt = new JICPPacket(0, 0, payload);
                pkt.setSessionID((byte)sid);
                pkt = this.deliver(pkt, null);
                this.log("Response received " + pkt.getSessionID(), 3);
                if (pkt.getType() == 100) {
                    throw new ICPException(new String(pkt.getData()));
                }
                return pkt.getData();
            }
            catch (IOException ioe) {
                this.log("IOException on output connection. " + ioe, 2);
                this.myDisconnectionManager.setUnreachable(false);
                throw new ICPException("Dispatching error.", ioe);
            }
        }
        throw new ICPException("Unreachable");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JICPPacket deliver(JICPPacket pkt, Connection c) throws IOException {
        JICPPacket jICPPacket;
        if (Thread.currentThread() == this.terminator) {
            pkt.setTerminatedInfo(true);
        }
        pkt.setRecipientID(this.mediatorTA.getFile());
        byte type = pkt.getType();
        if (c == null) {
            c = new HTTPClientConnection(this.mediatorTA);
        }
        int status = 0;
        try {
            try {
                c.writePacket(pkt);
                status = 1;
                pkt = c.readPacket();
                status = 2;
                jICPPacket = pkt;
                Object var7_7 = null;
            }
            catch (IOException ioe) {
                throw new IOException(ioe.getMessage() + '[' + status + ']');
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                c.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return jICPPacket;
        }
        c.close();
        return jICPPacket;
    }

    public void doTimeOut(Timer t) {
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void lock() {
        Object object = this.connectorLock;
        synchronized (object) {
            while (this.locked) {
                try {
                    this.connectorLock.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.locked = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock() {
        Object object = this.connectorLock;
        synchronized (object) {
            this.locked = false;
            this.connectorLock.notifyAll();
        }
    }

    private boolean ping(int cnt) throws ICPException {
        int i = -1;
        while (i < this.backEndAddresses.length) {
            if (i >= 0) {
                String addr = this.backEndAddresses[i];
                int colonPos = addr.indexOf(58);
                String host = addr.substring(0, colonPos);
                String port = addr.substring(colonPos + 1, addr.length());
                this.mediatorTA = new JICPAddress(host, port, this.myMediatorID, "");
            }
            try {
                this.log("Ping " + this.mediatorTA.getHost() + ":" + this.mediatorTA.getPort() + "(" + cnt + ")", 2);
                JICPPacket pkt = new JICPPacket(23, 0, null);
                pkt = this.deliver(pkt, null);
                if (pkt.getType() == 100) {
                    throw new ICPException("Mediator expired.");
                }
                return true;
            }
            catch (IOException ioe) {
                this.log(ioe.toString(), 2);
                ++i;
            }
        }
        this.log("Ping failed.", 2);
        return false;
    }

    private String[] parseBackEndAddresses(String addressesText) {
        Vector<String> addrs = new Vector<String>();
        if (addressesText != null && !addressesText.equals("")) {
            char[] addressesChars = new char[addressesText.length()];
            addressesText.getChars(0, addressesText.length(), addressesChars, 0);
            StringBuffer sbAddr = new StringBuffer();
            int i = 0;
            while (i < addressesChars.length) {
                char c = addressesChars[i];
                if (c != ',' && c != ';' && c != ' ' && c != '\n' && c != '\t') {
                    sbAddr.append(c);
                } else {
                    String tmp = sbAddr.toString().trim();
                    if (tmp.length() > 0) {
                        addrs.addElement(tmp);
                    }
                    sbAddr = new StringBuffer();
                }
                ++i;
            }
            String tmp = sbAddr.toString().trim();
            if (tmp.length() > 0) {
                addrs.addElement(tmp);
            }
        }
        String[] result = new String[addrs.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (String)addrs.elementAt(i);
            ++i;
        }
        return result;
    }

    void log(String s, int level) {
        if (this.verbosity >= level) {
            String name = Thread.currentThread().toString();
            Logger logger = Logger.getMyLogger(this.getClass().getName());
            logger.log(Logger.INFO, name + ": " + s);
        }
    }

    private class KeepAliveManager
    implements TimerListener {
        private long kaTimeout;
        private Timer kaTimer;

        private KeepAliveManager(long keepAliveTime) {
            this.kaTimeout = keepAliveTime * 2L;
        }

        public synchronized void doTimeOut(Timer t) {
            if (t == this.kaTimer) {
                HTTPFEDispatcher.this.log("Missing KA", 2);
                HTTPFEDispatcher.this.myDisconnectionManager.setUnreachable(true);
            }
        }

        private synchronized void update() {
            TimerDispatcher td = TimerDispatcher.getTimerDispatcher();
            if (this.kaTimer != null) {
                td.remove(this.kaTimer);
            }
            this.kaTimer = td.add(new Timer(System.currentTimeMillis() + this.kaTimeout, this));
        }
    }

    class DisconnectionManager
    implements Runnable {
        private boolean reachable = false;
        private boolean pingOK = false;
        private Thread myThread;
        private long retryTime;
        private long maxDisconnectionTime;

        private DisconnectionManager(long retryTime, long maxDisconnectionTime) {
            this.retryTime = retryTime;
            this.maxDisconnectionTime = maxDisconnectionTime;
        }

        private final synchronized boolean isReachable() {
            return this.reachable;
        }

        private synchronized void setUnreachable(boolean missingKA) {
            if (this.reachable && (missingKA || !this.pingOK)) {
                if (HTTPFEDispatcher.this.myConnectionListener != null) {
                    HTTPFEDispatcher.this.myConnectionListener.handleConnectionEvent(2, null);
                }
                HTTPFEDispatcher.this.log("Starting DM (" + System.currentTimeMillis() + ").", 2);
                this.reachable = false;
                this.myThread = new Thread(this);
                this.myThread.start();
                if (this.pingOK) {
                    HTTPFEDispatcher.this.myInputManager.kill();
                    HTTPFEDispatcher.this.myInputManager = new InputManager();
                    HTTPFEDispatcher.this.myInputManager.start();
                }
            }
        }

        private synchronized void setReachable() {
            this.reachable = true;
            if (HTTPFEDispatcher.this.myConnectionListener != null) {
                HTTPFEDispatcher.this.myConnectionListener.handleConnectionEvent(3, null);
            }
            this.notifyAll();
        }

        private synchronized void waitUntilReachable() {
            while (!this.reachable) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            this.pingOK = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block7: {
                int attemptCnt = 0;
                long startTime = System.currentTimeMillis();
                try {
                    while (!HTTPFEDispatcher.this.ping(attemptCnt)) {
                        ++attemptCnt;
                        if (System.currentTimeMillis() - startTime > this.maxDisconnectionTime) {
                            throw new ICPException("Max disconnection timeout expired");
                        }
                        this.waitABit(this.retryTime);
                    }
                    HTTPFEDispatcher.this.log("Ping OK.", 2);
                    DisconnectionManager disconnectionManager = this;
                    synchronized (disconnectionManager) {
                        this.pingOK = true;
                        this.setReachable();
                        HTTPFEDispatcher.this.myKeepAliveManager.update();
                        HTTPFEDispatcher.this.waitingForFlush = HTTPFEDispatcher.this.myStub.flush();
                    }
                }
                catch (ICPException icpe) {
                    HTTPFEDispatcher.this.log("Impossible to reconnect to the BackEnd (" + System.currentTimeMillis() + "). " + icpe.getMessage(), 0);
                    if (HTTPFEDispatcher.this.myConnectionListener == null) break block7;
                    HTTPFEDispatcher.this.myConnectionListener.handleConnectionEvent(5, null);
                }
            }
        }

        private void waitABit(long time) {
            try {
                HTTPFEDispatcher.this.log("Wait a bit (" + time + ")...", 3);
                Thread.sleep(time);
                HTTPFEDispatcher.this.log("Wake up", 3);
            }
            catch (InterruptedException ie) {}
        }
    }

    private class InputManager
    extends Thread {
        private boolean active = true;
        private Connection myConnection = null;
        private int myId;

        private InputManager() {
        }

        public void run() {
            if (HTTPFEDispatcher.this.cnt == 0) {
                Thread.yield();
                try {
                    HTTPFEDispatcher.this.myConnectionListener = (ConnectionListener)Class.forName(HTTPFEDispatcher.this.props.getProperty("connection-listener")).newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.myId = HTTPFEDispatcher.this.cnt++;
            HTTPFEDispatcher.this.log("IM-" + this.myId + " started", 1);
            block4: while (this.active) {
                this.myConnection = new HTTPClientConnection(HTTPFEDispatcher.this.mediatorTA);
                JICPPacket rsp = new JICPPacket(1, 0, null);
                try {
                    while (true) {
                        HTTPFEDispatcher.this.myDisconnectionManager.waitUntilReachable();
                        if (this.myConnection == null || !this.active) continue block4;
                        JICPPacket cmd = HTTPFEDispatcher.this.deliver(rsp, this.myConnection);
                        HTTPFEDispatcher.this.myKeepAliveManager.update();
                        if (cmd.getType() == 2) {
                            rsp = new JICPPacket(1, 32, null);
                            continue;
                        }
                        byte sid = cmd.getSessionID();
                        if (sid == HTTPFEDispatcher.this.lastSid) {
                            HTTPFEDispatcher.this.log("Duplicated command received " + sid, 2);
                            rsp = HTTPFEDispatcher.this.lastResponse;
                            continue;
                        }
                        HTTPFEDispatcher.this.log("Incoming command received " + sid, 3);
                        byte[] rspData = HTTPFEDispatcher.this.mySkel.handleCommand(cmd.getData());
                        HTTPFEDispatcher.this.log("Incoming command served " + sid, 3);
                        rsp = new JICPPacket(1, 0, rspData);
                        rsp.setSessionID(sid);
                        HTTPFEDispatcher.this.lastSid = sid;
                        HTTPFEDispatcher.this.lastResponse = rsp;
                    }
                }
                catch (IOException ioe) {
                    if (!this.active) continue;
                    HTTPFEDispatcher.this.log("IOException on input connection. " + ioe, 2);
                    HTTPFEDispatcher.this.myDisconnectionManager.setUnreachable(false);
                }
            }
            HTTPFEDispatcher.this.log("IM-" + this.myId + " terminated", 1);
        }

        private void kill() {
            this.active = false;
        }
    }
}

